*******************************************************
* AMAJOR.SRC                                          *
*                                                     *
* This program allows a musical scale to be played by *
* the console keyboard.  The mapping of keys is       *
*                                                     *
*        KEY      NOTE     FREQUENCY                  *
*        ===================================          *
*        SPACE    -        - (silence)                *
*        1        A        440.00 Hz                  *
*        2        B        493.88 Hz                  *
*        3        C#       554.37 Hz                  *
*        4        D        587.33 Hz                  *
*        5        E        659.26 Hz                  *
*        6        F#       739.99 Hz                  *
*        7        G#       930.61 Hz                  *
*        8        A'       880.00 Hz                  *
*******************************************************
DUART    EQU      $00C001 ;68681 base address
ACR      EQU      4*2     ;auxiliary control register
CTUR     EQU      6*2     ;counter/timer upper register
CTLR     EQU      7*2     ;counter/timer lower register
IMR      EQU      5*2     ;interrupt mask register
IVR      EQU      12*2    ;interrupt vector register
STOP     EQU      15*2    ;timer stop command address
I2VECTOR EQU      26      ;I2 autovector number
PIA      EQU      $10001  ;PIA base address
CRA      EQU      1*2     ;Control Register A
COUNT    EQU      11      ;timer interrupts @ 10472.7 Hz

         ORG      $8000
AMAJOR   JMP      INIT
         JMP      L2ISR
INIT     MOVEA.L  #DUART,A0     ;A0 -> 68681 DUART
         MOVEA.L  #TABLE,A1     ;A1 -> sine wave table
         MOVEA.L  #PIA,A2       ;A2 -> DDRA
         MOVEA.L  #SCALE,A3     ;A3 -> scale table
         MOVE.B   #$08,IMR(A0)
         MOVE.B   #I2VECTOR,IVR(A0)
         MOVE.W   #COUNT,D0
         MOVEP.W  D0,CTUR(A0)
         MOVE.B   #$70,ACR(A0)

         MOVE.B   #$FF,(A2)     ;Port A = output
         MOVE.B   #$04,CRA(A2)  ;A2 -> Port A
         CLR.W    STEP         ;begin with silence
         CLR.W    D1            ;beginning of sine wave
         ORI.W    #$0700,SR     ;mask all interrupts
         ANDI.W   #$F9FF,SR     ;mask level 1 only
HERE     BRA      HERE          ;off we go!

*******************************************************
* LEVEL-2 INTERRUPT SERVICE ROUTINE                   *
*                                                     *
*        -issue STOP command to clear interrupt       *
*        -send new DATA to MC1408L8 DAC using STEP    *
*        -check if a key has been hit                 *
*        -if a key has been hit, set new STEP value   *
*******************************************************
L2ISR    TST.B    STOP(A0)      ;stop cmd, clrs intrrpt
         MOVE.B   0(A1,D1.W),D0 ;get new data
         MOVE.B   D0,(A2)       ;sent to DAC
         ADD.W    STEP,D1      ;increment index
         ANDI.W   #$3FF,D1      ;reduce to 10 bits
SKIP     TRAP     #4            ;has a key been hit?
         BCC      DONE          ;no:  done
         TRAP     #0            ;yes: get ASCII code
         ANDI.W   #$0F,D0       ;reduce to 4 bits
         MOVE.B   0(A3,D0.W),STEP+1 ;get new index
DONE     RTE

*******************************************************
* The following scale table sets the increment        *
* through the sine wave table for each note in an A   *
* major scale.                                        *
*                                                     *
* Each entry = fN x (1024 / fC), where fN is the note *
* frequency and fC is the conversion frequency.  For  *
* example the entry for A is 440 x (1024 / 10472.7) = *
* 43.                                                 *
*******************************************************
SCALE    DC.B     0             ;silence (SPACE)
         DC.B     43            ;A
         DC.B     48            ;B
         DC.B     54            ;C#
         DC.B     57            ;D
         DC.B     64            ;E
         DC.B     72            ;F#
         DC.B     81            ;G#
         DC.B     86            ;A'

*******************************************************
* The following sine wave table contains 1024 entries *
* of integers between 0 and 255.                      *
*******************************************************
TABLE    DC.B 127
         DC.B 128
         DC.B 129
         DC.B 129
         DC.B 130
* Turn listing off after first five entries
* LSTOUT-
 DC.B 131
 DC.B 132
 DC.B 132
 DC.B 133
 DC.B 134
 DC.B 135
 DC.B 136
 DC.B 136
 DC.B 137
 DC.B 138
 DC.B 139
 DC.B 139
 DC.B 140
 DC.B 141
 DC.B 142
 DC.B 143
 DC.B 143
 DC.B 144
 DC.B 145
 DC.B 146
 DC.B 146
 DC.B 147
 DC.B 148
 DC.B 149
 DC.B 150
 DC.B 150
 DC.B 151
 DC.B 152
 DC.B 153
 DC.B 153
 DC.B 154
 DC.B 155
 DC.B 156
 DC.B 156
 DC.B 157
 DC.B 158
 DC.B 159
 DC.B 159
 DC.B 160
 DC.B 161
 DC.B 162
 DC.B 163
 DC.B 163
 DC.B 164
 DC.B 165
 DC.B 166
 DC.B 166
 DC.B 167
 DC.B 168
 DC.B 168
 DC.B 169
 DC.B 170
 DC.B 171
 DC.B 171
 DC.B 172
 DC.B 173
 DC.B 174
 DC.B 174
 DC.B 175
 DC.B 176
 DC.B 177
 DC.B 177
 DC.B 178
 DC.B 179
 DC.B 179
 DC.B 180
 DC.B 181
 DC.B 182
 DC.B 182
 DC.B 183
 DC.B 184
 DC.B 184
 DC.B 185
 DC.B 186
 DC.B 186
 DC.B 187
 DC.B 188
 DC.B 188
 DC.B 189
 DC.B 190
 DC.B 191
 DC.B 191
 DC.B 192
 DC.B 193
 DC.B 193
 DC.B 194
 DC.B 195
 DC.B 195
 DC.B 196
 DC.B 197
 DC.B 197
 DC.B 198
 DC.B 198
 DC.B 199
 DC.B 200
 DC.B 200
 DC.B 201
 DC.B 202
 DC.B 202
 DC.B 203
 DC.B 204
 DC.B 204
 DC.B 205
 DC.B 205
 DC.B 206
 DC.B 207
 DC.B 207
 DC.B 208
 DC.B 208
 DC.B 209
 DC.B 210
 DC.B 210
 DC.B 211
 DC.B 211
 DC.B 212
 DC.B 213
 DC.B 213
 DC.B 214
 DC.B 214
 DC.B 215
 DC.B 215
 DC.B 216
 DC.B 217
 DC.B 217
 DC.B 218
 DC.B 218
 DC.B 219
 DC.B 219
 DC.B 220
 DC.B 220
 DC.B 221
 DC.B 221
 DC.B 222
 DC.B 223
 DC.B 223
 DC.B 224
 DC.B 224
 DC.B 225
 DC.B 225
 DC.B 226
 DC.B 226
 DC.B 227
 DC.B 227
 DC.B 228
 DC.B 228
 DC.B 228
 DC.B 229
 DC.B 229
 DC.B 230
 DC.B 230
 DC.B 231
 DC.B 231
 DC.B 232
 DC.B 232
 DC.B 233
 DC.B 233
 DC.B 233
 DC.B 234
 DC.B 234
 DC.B 235
 DC.B 235
 DC.B 236
 DC.B 236
 DC.B 236
 DC.B 237
 DC.B 237
 DC.B 238
 DC.B 238
 DC.B 238
 DC.B 239
 DC.B 239
 DC.B 239
 DC.B 240
 DC.B 240
 DC.B 241
 DC.B 241
 DC.B 241
 DC.B 242
 DC.B 242
 DC.B 242
 DC.B 243
 DC.B 243
 DC.B 243
 DC.B 244
 DC.B 244
 DC.B 244
 DC.B 244
 DC.B 245
 DC.B 245
 DC.B 245
 DC.B 246
 DC.B 246
 DC.B 246
 DC.B 247
 DC.B 247
 DC.B 247
 DC.B 247
 DC.B 248
 DC.B 248
 DC.B 248
 DC.B 248
 DC.B 249
 DC.B 249
 DC.B 249
 DC.B 249
 DC.B 249
 DC.B 250
 DC.B 250
 DC.B 250
 DC.B 250
 DC.B 250
 DC.B 251
 DC.B 251
 DC.B 251
 DC.B 251
 DC.B 251
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 251
 DC.B 251
 DC.B 251
 DC.B 251
 DC.B 251
 DC.B 250
 DC.B 250
 DC.B 250
 DC.B 250
 DC.B 250
 DC.B 249
 DC.B 249
 DC.B 249
 DC.B 249
 DC.B 249
 DC.B 248
 DC.B 248
 DC.B 248
 DC.B 248
 DC.B 247
 DC.B 247
 DC.B 247
 DC.B 247
 DC.B 246
 DC.B 246
 DC.B 246
 DC.B 245
 DC.B 245
 DC.B 245
 DC.B 244
 DC.B 244
 DC.B 244
 DC.B 244
 DC.B 243
 DC.B 243
 DC.B 243
 DC.B 242
 DC.B 242
 DC.B 242
 DC.B 241
 DC.B 241
 DC.B 241
 DC.B 240
 DC.B 240
 DC.B 239
 DC.B 239
 DC.B 239
 DC.B 238
 DC.B 238
 DC.B 238
 DC.B 237
 DC.B 237
 DC.B 236
 DC.B 236
 DC.B 236
 DC.B 235
 DC.B 235
 DC.B 234
 DC.B 234
 DC.B 233
 DC.B 233
 DC.B 233
 DC.B 232
 DC.B 232
 DC.B 231
 DC.B 231
 DC.B 230
 DC.B 230
 DC.B 229
 DC.B 229
 DC.B 228
 DC.B 228
 DC.B 228
 DC.B 227
 DC.B 227
 DC.B 226
 DC.B 226
 DC.B 225
 DC.B 225
 DC.B 224
 DC.B 224
 DC.B 223
 DC.B 223
 DC.B 222
 DC.B 221
 DC.B 221
 DC.B 220
 DC.B 220
 DC.B 219
 DC.B 219
 DC.B 218
 DC.B 218
 DC.B 217
 DC.B 217
 DC.B 216
 DC.B 215
 DC.B 215
 DC.B 214
 DC.B 214
 DC.B 213
 DC.B 213
 DC.B 212
 DC.B 211
 DC.B 211
 DC.B 210
 DC.B 210
 DC.B 209
 DC.B 208
 DC.B 208
 DC.B 207
 DC.B 207
 DC.B 206
 DC.B 205
 DC.B 205
 DC.B 204
 DC.B 204
 DC.B 203
 DC.B 202
 DC.B 202
 DC.B 201
 DC.B 200
 DC.B 200
 DC.B 199
 DC.B 198
 DC.B 198
 DC.B 197
 DC.B 197
 DC.B 196
 DC.B 195
 DC.B 195
 DC.B 194
 DC.B 193
 DC.B 193
 DC.B 192
 DC.B 191
 DC.B 191
 DC.B 190
 DC.B 189
 DC.B 188
 DC.B 188
 DC.B 187
 DC.B 186
 DC.B 186
 DC.B 185
 DC.B 184
 DC.B 184
 DC.B 183
 DC.B 182
 DC.B 182
 DC.B 181
 DC.B 180
 DC.B 179
 DC.B 179
 DC.B 178
 DC.B 177
 DC.B 177
 DC.B 176
 DC.B 175
 DC.B 174
 DC.B 174
 DC.B 173
 DC.B 172
 DC.B 171
 DC.B 171
 DC.B 170
 DC.B 169
 DC.B 168
 DC.B 168
 DC.B 167
 DC.B 166
 DC.B 166
 DC.B 165
 DC.B 164
 DC.B 163
 DC.B 163
 DC.B 162
 DC.B 161
 DC.B 160
 DC.B 159
 DC.B 159
 DC.B 158
 DC.B 157
 DC.B 156
 DC.B 156
 DC.B 155
 DC.B 154
 DC.B 153
 DC.B 153
 DC.B 152
 DC.B 151
 DC.B 150
 DC.B 150
 DC.B 149
 DC.B 148
 DC.B 147
 DC.B 146
 DC.B 146
 DC.B 145
 DC.B 144
 DC.B 143
 DC.B 143
 DC.B 142
 DC.B 141
 DC.B 140
 DC.B 139
 DC.B 139
 DC.B 138
 DC.B 137
 DC.B 136
 DC.B 136
 DC.B 135
 DC.B 134
 DC.B 133
 DC.B 132
 DC.B 132
 DC.B 131
 DC.B 130
 DC.B 129
 DC.B 129
 DC.B 128
 DC.B 127
 DC.B 126
 DC.B 125
 DC.B 125
 DC.B 124
 DC.B 123
 DC.B 122
 DC.B 122
 DC.B 121
 DC.B 120
 DC.B 119
 DC.B 118
 DC.B 118
 DC.B 117
 DC.B 116
 DC.B 115
 DC.B 115
 DC.B 114
 DC.B 113
 DC.B 112
 DC.B 111
 DC.B 111
 DC.B 110
 DC.B 109
 DC.B 108
 DC.B 108
 DC.B 107
 DC.B 106
 DC.B 105
 DC.B 104
 DC.B 104
 DC.B 103
 DC.B 102
 DC.B 101
 DC.B 101
 DC.B 100
 DC.B  99
 DC.B  98
 DC.B  98
 DC.B  97
 DC.B  96
 DC.B  95
 DC.B  95
 DC.B  94
 DC.B  93
 DC.B  92
 DC.B  91
 DC.B  91
 DC.B  90
 DC.B  89
 DC.B  88
 DC.B  88
 DC.B  87
 DC.B  86
 DC.B  86
 DC.B  85
 DC.B  84
 DC.B  83
 DC.B  83
 DC.B  82
 DC.B  81
 DC.B  80
 DC.B  80
 DC.B  79
 DC.B  78
 DC.B  77
 DC.B  77
 DC.B  76
 DC.B  75
 DC.B  75
 DC.B  74
 DC.B  73
 DC.B  72
 DC.B  72
 DC.B  71
 DC.B  70
 DC.B  70
 DC.B  69
 DC.B  68
 DC.B  68
 DC.B  67
 DC.B  66
 DC.B  66
 DC.B  65
 DC.B  64
 DC.B  63
 DC.B  63
 DC.B  62
 DC.B  61
 DC.B  61
 DC.B  60
 DC.B  59
 DC.B  59
 DC.B  58
 DC.B  57
 DC.B  57
 DC.B  56
 DC.B  56
 DC.B  55
 DC.B  54
 DC.B  54
 DC.B  53
 DC.B  52
 DC.B  52
 DC.B  51
 DC.B  50
 DC.B  50
 DC.B  49
 DC.B  49
 DC.B  48
 DC.B  47
 DC.B  47
 DC.B  46
 DC.B  46
 DC.B  45
 DC.B  44
 DC.B  44
 DC.B  43
 DC.B  43
 DC.B  42
 DC.B  41
 DC.B  41
 DC.B  40
 DC.B  40
 DC.B  39
 DC.B  39
 DC.B  38
 DC.B  37
 DC.B  37
 DC.B  36
 DC.B  36
 DC.B  35
 DC.B  35
 DC.B  34
 DC.B  34
 DC.B  33
 DC.B  33
 DC.B  32
 DC.B  31
 DC.B  31
 DC.B  30
 DC.B  30
 DC.B  29
 DC.B  29
 DC.B  28
 DC.B  28
 DC.B  27
 DC.B  27
 DC.B  26
 DC.B  26
 DC.B  26
 DC.B  25
 DC.B  25
 DC.B  24
 DC.B  24
 DC.B  23
 DC.B  23
 DC.B  22
 DC.B  22
 DC.B  21
 DC.B  21
 DC.B  21
 DC.B  20
 DC.B  20
 DC.B  19
 DC.B  19
 DC.B  18
 DC.B  18
 DC.B  18
 DC.B  17
 DC.B  17
 DC.B  16
 DC.B  16
 DC.B  16
 DC.B  15
 DC.B  15
 DC.B  15
 DC.B  14
 DC.B  14
 DC.B  13
 DC.B  13
 DC.B  13
 DC.B  12
 DC.B  12
 DC.B  12
 DC.B  11
 DC.B  11
 DC.B  11
 DC.B  10
 DC.B  10
 DC.B  10
 DC.B  10
 DC.B   9
 DC.B   9
 DC.B   9
 DC.B   8
 DC.B   8
 DC.B   8
 DC.B   7
 DC.B   7
 DC.B   7
 DC.B   7
 DC.B   6
 DC.B   6
 DC.B   6
 DC.B   6
 DC.B   5
 DC.B   5
 DC.B   5
 DC.B   5
 DC.B   5
 DC.B   4
 DC.B   4
 DC.B   4
 DC.B   4
 DC.B   4
 DC.B   3
 DC.B   3
 DC.B   3
 DC.B   3
 DC.B   3
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   3
 DC.B   3
 DC.B   3
 DC.B   3
 DC.B   3
 DC.B   4
 DC.B   4
 DC.B   4
 DC.B   4
 DC.B   4
 DC.B   5
 DC.B   5
 DC.B   5
 DC.B   5
 DC.B   5
 DC.B   6
 DC.B   6
 DC.B   6
 DC.B   6
 DC.B   7
 DC.B   7
 DC.B   7
 DC.B   7
 DC.B   8
 DC.B   8
 DC.B   8
 DC.B   9
 DC.B   9
 DC.B   9
 DC.B  10
 DC.B  10
 DC.B  10
 DC.B  10
 DC.B  11
 DC.B  11
 DC.B  11
 DC.B  12
 DC.B  12
 DC.B  12
 DC.B  13
 DC.B  13
 DC.B  13
 DC.B  14
 DC.B  14
 DC.B  15
 DC.B  15
 DC.B  15
 DC.B  16
 DC.B  16
 DC.B  16
 DC.B  17
 DC.B  17
 DC.B  18
 DC.B  18
 DC.B  18
 DC.B  19
 DC.B  19
 DC.B  20
 DC.B  20
 DC.B  21
 DC.B  21
 DC.B  21
 DC.B  22
 DC.B  22
 DC.B  23
 DC.B  23
 DC.B  24
 DC.B  24
 DC.B  25
 DC.B  25
 DC.B  26
 DC.B  26
 DC.B  26
 DC.B  27
 DC.B  27
 DC.B  28
 DC.B  28
 DC.B  29
 DC.B  29
 DC.B  30
 DC.B  30
 DC.B  31
 DC.B  31
 DC.B  32
 DC.B  33
 DC.B  33
 DC.B  34
 DC.B  34
 DC.B  35
 DC.B  35
 DC.B  36
 DC.B  36
 DC.B  37
 DC.B  37
 DC.B  38
 DC.B  39
 DC.B  39
 DC.B  40
 DC.B  40
 DC.B  41
 DC.B  41
 DC.B  42
 DC.B  43
 DC.B  43
 DC.B  44
 DC.B  44
 DC.B  45
 DC.B  46
 DC.B  46
 DC.B  47
 DC.B  47
 DC.B  48
 DC.B  49
 DC.B  49
 DC.B  50
 DC.B  50
 DC.B  51
 DC.B  52
 DC.B  52
 DC.B  53
 DC.B  54
 DC.B  54
 DC.B  55
 DC.B  56
 DC.B  56
 DC.B  57
 DC.B  57
 DC.B  58
 DC.B  59
 DC.B  59
 DC.B  60
 DC.B  61
 DC.B  61
 DC.B  62
 DC.B  63
 DC.B  63
 DC.B  64
 DC.B  65
 DC.B  66
 DC.B  66
 DC.B  67
 DC.B  68
 DC.B  68
 DC.B  69
 DC.B  70
 DC.B  70
 DC.B  71
 DC.B  72
 DC.B  72
 DC.B  73
 DC.B  74
 DC.B  75
 DC.B  75
 DC.B  76
 DC.B  77
 DC.B  77
 DC.B  78
 DC.B  79
 DC.B  80
 DC.B  80
 DC.B  81
 DC.B  82
 DC.B  83
 DC.B  83
 DC.B  84
 DC.B  85
 DC.B  86
 DC.B  86
 DC.B  87
 DC.B  88
 DC.B  88
 DC.B  89
 DC.B  90
 DC.B  91
 DC.B  91
 DC.B  92
 DC.B  93
 DC.B  94
 DC.B  95
 DC.B  95
 DC.B  96
 DC.B  97
 DC.B  98
 DC.B  98
 DC.B  99
 DC.B 100
 DC.B 101
 DC.B 101
 DC.B 102
 DC.B 103
 DC.B 104
 DC.B 104
 DC.B 105
 DC.B 106
 DC.B 107
 DC.B 108
 DC.B 108
 DC.B 109
 DC.B 110
 DC.B 111
 DC.B 111
 DC.B 112
 DC.B 113
 DC.B 114
 DC.B 115
 DC.B 115
 DC.B 116
 DC.B 117
 DC.B 118
 DC.B 118
 DC.B 119
 DC.B 120
 DC.B 121
 DC.B 122
 DC.B 122
*         LSTOUT+
*------------------------------------------------------
* Turn listing on for last five entries
         DC.B 123
         DC.B 124
         DC.B 125
         DC.B 125
         DC.B 126

         ORG      $A000
STEP     DC.W     1
         END      AMAJOR
